/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.jei;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.integration.jei.RecipeWrapperHollowCover;
import com.raoulvdberge.refinedstorage.item.ItemCover;
import com.raoulvdberge.refinedstorage.item.ItemHollowCover;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeRegistryPluginHollowCover
implements IRecipeRegistryPlugin {
    @Nonnull
    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        if (focus.getValue() instanceof ItemStack) {
            ItemStack stack = (ItemStack)focus.getValue();
            if (focus.getMode() == IFocus.Mode.INPUT) {
                if (stack.func_77973_b() == RSItems.COVER) {
                    ItemStack itemInCover = ItemCover.getItem(stack);
                    if (!RS.INSTANCE.config.hideCovers && CoverManager.isValidCover(itemInCover) || API.instance().getComparer().isEqualNoQuantity(itemInCover, ItemHollowCover.HIDDEN_COVER_ALTERNATIVE)) {
                        return Collections.singletonList("minecraft.crafting");
                    }
                }
            } else if (focus.getMode() == IFocus.Mode.OUTPUT && stack.func_77973_b() == RSItems.HOLLOW_COVER) {
                return Collections.singletonList("minecraft.crafting");
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(@Nonnull IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (focus.getValue() instanceof ItemStack) {
            ItemStack stack = (ItemStack)focus.getValue();
            if (focus.getMode() == IFocus.Mode.INPUT) {
                if (stack.func_77973_b() == RSItems.COVER) {
                    ItemStack itemInCover = ItemCover.getItem(stack);
                    if (!RS.INSTANCE.config.hideCovers && CoverManager.isValidCover(itemInCover) || API.instance().getComparer().isEqualNoQuantity(itemInCover, ItemHollowCover.HIDDEN_COVER_ALTERNATIVE)) {
                        ItemStack hollowCover = new ItemStack((Item)RSItems.HOLLOW_COVER);
                        ItemCover.setItem(hollowCover, itemInCover);
                        return Collections.singletonList(new RecipeWrapperHollowCover(stack, hollowCover));
                    }
                }
            } else if (focus.getMode() == IFocus.Mode.OUTPUT && stack.func_77973_b() == RSItems.HOLLOW_COVER) {
                ItemStack cover = new ItemStack((Item)RSItems.COVER);
                ItemCover.setItem(cover, ItemCover.getItem(stack));
                return Collections.singletonList(new RecipeWrapperHollowCover(cover, stack));
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(@Nonnull IRecipeCategory<T> recipeCategory) {
        return Collections.emptyList();
    }
}

